<?php
require_once __DIR__ . '/config/config.php';

$pageTitle = 'انتخاب کشور';

// Load static list of countries (no API call needed here)
$countries = require __DIR__ . '/data/countries.php';

include __DIR__ . '/includes/header.php';
?>

<div class="hero-section">
    <div class="container">
        <h1>خرید eSIM برای سفرهای بین‌المللی</h1>
        <p>بهترین بسته‌های اینترنت برای بیش از 200 کشور جهان</p>
    </div>
</div>

<div class="container">
    <div class="search-box">
        <i class="fas fa-search"></i>
        <input type="text" id="countrySearch" placeholder="جستجوی کشور...">
    </div>

    <div class="countries-grid" id="countriesGrid">
        <?php foreach ($countries as $country): ?>
        <a href="/country.php?code=<?php echo htmlspecialchars($country['iso']); ?>" class="country-card" data-name="<?php echo htmlspecialchars($country['name']); ?>">
            <div class="country-flag">
                <img src="https://flagcdn.com/w160/<?php echo strtolower($country['iso']); ?>.png" 
                     alt="<?php echo htmlspecialchars($country['name']); ?>"
                     onerror="this.src='https://via.placeholder.com/160x120?text=<?php echo htmlspecialchars($country['iso']); ?>'">
            </div>
            <div class="country-name">
                <?php echo htmlspecialchars($country['name']); ?>
            </div>
            <div class="country-code">
                <?php echo htmlspecialchars($country['iso']); ?>
            </div>
        </a>
        <?php endforeach; ?>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>